package com.example.sefinsa_app.ui.avales.crear;

import android.annotation.SuppressLint;
import android.app.ProgressDialog;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.location.Location;
import android.location.LocationManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import android.provider.MediaStore;
import android.provider.Settings;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.appcompat.app.AlertDialog;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.ViewModelProvider;

import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.ColaSolicitudes;
import com.example.sefinsa_app.R;
import com.example.sefinsa_app.SolicitudSubida;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.controllers.AvalController;
import com.example.sefinsa_app.controllers.ClienteController;
import com.example.sefinsa_app.controllers.ColocadoraController;
import com.example.sefinsa_app.controllers.PoblacionController;
import com.example.sefinsa_app.controllers.RutaController;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Aval;
import com.example.sefinsa_app.models.Cliente;
import com.example.sefinsa_app.models.Colocadora;
import com.example.sefinsa_app.models.Poblacion;
import com.example.sefinsa_app.models.Ruta;
import com.example.sefinsa_app.ui.avales.fotos.AvalesFotosDialogFragment;
import com.example.sefinsa_app.ui.avales.fotos.AvalesFotosFragment;
import com.example.sefinsa_app.utilities.CurrentFragment;
import com.example.sefinsa_app.utilities.ErrorChecker;
import com.example.sefinsa_app.utilities.ResponseMe;
import com.example.sefinsa_app.utilities.RetrofitInterface;
import com.example.sefinsa_app.utilities.Validator;
import com.example.sefinsa_app.utilities.VolleyS;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import com.google.android.material.textfield.TextInputLayout;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;

import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class AvalesCrearFragment extends Fragment implements AvalesFotosFragment.OnPhotosSelectedListener {

    private AvalesCrearViewModel mViewModel;

    private Button btnRegistrarAval, btnSubirFotos;

    private TextInputLayout tlNombreAval, tlTelefonoAval, tlDireccionAval, tlOtrasReferenciasAval, tlGarantiasAval;

    private Uri image_uri, uri;
    private final int CODIGO_PERMISOS_CAMARA = 1;
    private final boolean camaraGarantiasClienteAbierta = false;
    private final boolean camaraComprobantesClienteAbierta = false;
    private final boolean camaraGarantiasAvalAbierta = false;
    private final boolean camaraComprobantesAvalAbierta = false;
    private final boolean camarapathsINEAval = false;
    private final boolean camarapathsFotoAval = false;
    private final boolean camarapathsFachadaAval = false;

    private AutoCompleteTextView clientesAutoCompleteTextView, rutasAutoCompleteTextView,
            poblacionesAutoCompleteTextView, colocadorasAutoCompleteTextView, avalesAutoCompleteTextView;

    private VolleyS vs;
    private RequestQueue requestQueue;

    private ArrayList<Aval> avales;
    private ArrayAdapter<Aval> avalesAdapter;

    private ArrayList<Ruta> rutas;
    private ArrayAdapter<Ruta> rutasAdapter;

    private ArrayList<Poblacion> poblaciones;
    private ArrayAdapter<Poblacion> poblacionesAdapter;

    private ArrayList<Colocadora> colocadoras;
    private ArrayAdapter<Colocadora> colocadorasAdapter;

    private String ruta_id = "", poblacion_id = "", colocadora_id = "", aval_id = "";

    private int previousLengthAval;
    private boolean backSpaceAval;

    private AvalController avalController;
    private RutaController rutaController;
    private PoblacionController poblacionController;
    private ColocadoraController colocadoraController;

    private SharedPreferences sesion;

    private ArrayList<String> pathsGarantiasAval;
    private ArrayList<String> pathsComprobantesAval;
    private ArrayList<String> pathsFotoAval;
    private ArrayList<String> pathsIneAval;
    private ArrayList<String> pathsFachadaAval;

    List<MultipartBody.Part> archivosGeneral;

    Bundle bundle;

    private final ColaSolicitudes colaSolicitudes = ColaSolicitudes.getInstance();

    String path;
    String lat = "";
    String lgt = "";
    private int banderaGarantiasAval, banderaComprobantesAval;

    public static AvalesCrearFragment newInstance() {
        return new AvalesCrearFragment();
    }

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container,
                             @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_avales_crear, container, false);
    }

    @Override
    public void onPhotosSelected(ArrayList<String> pathsComprobantesAval2,
                                 ArrayList<String> pathsGarantiasAval2,
                                 ArrayList<String> pathsIneAval2,
                                 ArrayList<String> pathsFotoAval2,
                                 ArrayList<String> pathsFachadaAval2,
                                 List<MultipartBody.Part> archivosGeneral2) {


        // Inicializar y limpiar las listas si es necesario
        if (this.archivosGeneral == null) {
            this.archivosGeneral = new ArrayList<>();
        }
        this.archivosGeneral.clear();

        if (this.pathsComprobantesAval == null) {
            this.pathsComprobantesAval = new ArrayList<>();
        }
        this.pathsComprobantesAval.clear();

        if (this.pathsGarantiasAval == null) {
            this.pathsGarantiasAval = new ArrayList<>();
        }
        this.pathsGarantiasAval.clear();

        if (this.pathsIneAval == null) {
            this.pathsIneAval = new ArrayList<>();
        }
        this.pathsIneAval.clear();

        if (this.pathsFotoAval == null) {
            this.pathsFotoAval = new ArrayList<>();
        }
        this.pathsFotoAval.clear();

        if (this.pathsFachadaAval == null) {
            this.pathsFachadaAval = new ArrayList<>();
        }
        this.pathsFachadaAval.clear();

        // Agregar archivos de las diferentes listas a pathsComprobantesAval

        if (pathsIneAval2 != null) {
            this.pathsIneAval.addAll(pathsIneAval2);
        }
        if (pathsComprobantesAval2 != null) {
            this.pathsComprobantesAval.addAll(pathsComprobantesAval2);
        }
        if (pathsFotoAval2 != null) {
            this.pathsFotoAval.addAll(pathsFotoAval2);
        }
        if (pathsFachadaAval2 != null) {
            this.pathsFachadaAval.addAll(pathsFachadaAval2);
        }
        if (pathsGarantiasAval2 != null) {
            this.pathsGarantiasAval.addAll(pathsGarantiasAval2);
        }

        // Procesar los archivos Comprobantes, INE, Foto y Fachada con su sufijo correspondiente
        int index = 0;
        // Procesar INE
        if (pathsIneAval != null) {
            for (String path : pathsIneAval) {
                procesarArchivo(path, index, "CA.jpeg");  // IN = INE
                index++;
                //Log.d("LOG", "Procesado Comprobante Aval: " + path);
            }
        }
        // Procesar comprobantes y otros documentos
        if (pathsComprobantesAval != null) {
            for (String path : pathsComprobantesAval) {
                procesarArchivo(path, index, "CA.jpeg");  // CA = Comprobante Aval
                index++;
                //Log.d("LOG", "Procesado Comprobante Aval: " + path);
            }
        }
        // Procesar Foto Aval
        if (pathsFotoAval != null) {
            for (String path : pathsFotoAval) {
                procesarArchivo(path, index, "CA.jpeg");  // FO = Foto Aval
                index++;
                //Log.d("LOG", "Procesado Comprobante Aval: " + path);
            }
        }

        // Procesar Fachada Aval
        if (pathsFachadaAval != null) {
            for (String path : pathsFachadaAval) {
                procesarArchivo(path, index, "CA.jpeg");  // FA = Fachada Aval
                index++;
                //Log.d("LOG", "Procesado Comprobante Aval: " + path);
            }
        }

        // Procesar archivos de Garantías por separado
        int indexGarantias = 0;
        if (pathsGarantiasAval != null) {
            for (String path : pathsGarantiasAval) {
                procesarArchivoGarantia(path, indexGarantias);
                indexGarantias++;
            }
        }

        //Log.d("log", "Total de archivos en archivosGeneral: " + archivosGeneral.size());
    }

    // Método para procesar archivos y añadirlos a archivosGeneral
    private void procesarArchivo(String path, int index, String suffix) {
        File file = new File(path);
        if (file.exists()) {
            try {
                // Comprimir la imagen
                Bitmap bitmap = BitmapFactory.decodeFile(path);
                Bitmap reduceBitmap = resizeBitmap(bitmap, 1400);
                File compressedFile = saveBitmapToFile(reduceBitmap);

                // Crear el cuerpo de la solicitud para las garantías
                RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), compressedFile);
                MultipartBody.Part body = MultipartBody.Part.createFormData("archivo_aval_" + index, index + suffix, requestFile);

                archivosGeneral.add(body);
                //Log.d("MOD", "Archivo procesarArchivo de comprobante " + index + " agregado: " + compressedFile.getAbsolutePath());
            } catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            Log.d("log", "El archivo no existe: " + path);
        }
    }

    // Método para procesar archivos de Garantías por separado
    private void procesarArchivoGarantia(String path, int index) {
        File file = new File(path);
        if (file.exists()) {
            try {
                // Comprimir la imagen
                Bitmap bitmap = BitmapFactory.decodeFile(path);
                Bitmap reduceBitmap = resizeBitmap(bitmap, 1400);
                File compressedFile = saveBitmapToFile(reduceBitmap);

                // Crear el cuerpo de la solicitud para las garantías
                RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), compressedFile);
                MultipartBody.Part body = MultipartBody.Part.createFormData("garantia_aval_" + index, index + "GA.jpeg", requestFile);

                archivosGeneral.add(body);
                //Log.d("MOD", "Archivo de Garantía " + index + " agregado: " + compressedFile.getAbsolutePath());
            } catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            Log.d("log", "El archivo de garantía no existe: " + path);
        }
    }

    private Bitmap makeMutable(Bitmap bitmap) {
        return bitmap.copy(Bitmap.Config.ARGB_8888, true);
    }


    private Bitmap resizeBitmap(Bitmap bitmap, int maxSize) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        float bitmapRatio = (float) width / (float) height;

        if (bitmapRatio > 1) {
            width = maxSize;
            height = (int) (width / bitmapRatio);
        } else {
            height = maxSize;
            width = (int) (height * bitmapRatio);
        }

        Bitmap resizedBitmap = Bitmap.createScaledBitmap(bitmap, width, height, true);
        addDateTimeToBitmap(resizedBitmap);
        return resizedBitmap;
    }


    private File saveBitmapToFile(Bitmap bitmap) throws IOException {
        File file = File.createTempFile("compressed_image", ".jpeg");
        FileOutputStream fos = new FileOutputStream(file);
        bitmap.compress(Bitmap.CompressFormat.JPEG, 90, fos);
        fos.flush();
        fos.close();
        return file;
    }

    private String getCurrentDateTime() {
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", new Locale("es", "MX"));
        String dateTime = sdf.format(now);
        return dateTime.toUpperCase();
    }

    private void addDateTimeToBitmap(Bitmap bitmap) {
        // Asegurarse de que el bitmap sea mutable
        Bitmap mutableBitmap = makeMutable(bitmap);

        String currentDateTime = getCurrentDateTime();

        Canvas canvas = new Canvas(mutableBitmap);

        Paint backgroundPaint = new Paint();
        backgroundPaint.setColor(Color.parseColor("#80000000"));
        canvas.drawRect(0, mutableBitmap.getHeight() - 40, mutableBitmap.getWidth(), mutableBitmap.getHeight(), backgroundPaint);

        Paint textPaint = new Paint();
        textPaint.setColor(Color.WHITE); // Color del texto
        textPaint.setTextSize(18); // Tamaño del texto
        textPaint.setAntiAlias(true); // Suavizar el texto

        float x = 10;
        float y = mutableBitmap.getHeight() - 15;

        canvas.drawText(currentDateTime, x, y, textPaint);
    }


    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        //setHasOptionsMenu(true);

    }

    private void showAlert(String message) {
        AlertDialog.Builder builder = new AlertDialog.Builder(getActivity());
        builder.setMessage(message);

        // Personaliza el título para centrarlo
        TextView title = new TextView(getActivity());
        title.setText("Alerta");
        title.setGravity(Gravity.CENTER);
        title.setTextSize(TypedValue.COMPLEX_UNIT_SP, 20);
        title.setTextColor(ContextCompat.getColor(getActivity(), android.R.color.black));
        title.setPadding(0, 20, 0, 20);

        builder.setCustomTitle(title);

        builder.setPositiveButton("Aceptar", new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int id) {
                // Acciones al hacer clic en Aceptar
            }
        });

        AlertDialog dialog = builder.create();
        dialog.show();
    }


    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        sesion = getActivity().getSharedPreferences("sesion", Context.MODE_PRIVATE);


        initElements(view);

        avales = new ArrayList<Aval>();

        avalesAdapter = new ArrayAdapter<Aval>(getContext(), android.R.layout.simple_dropdown_item_1line, avales);
        avalesAutoCompleteTextView.setThreshold(1);
        avalesAutoCompleteTextView.setAdapter(avalesAdapter);

        avalesAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                if (!tlNombreAval.getEditText().getText().toString().isEmpty() || tlNombreAval.getEditText().getText() != null) {
                    ClienteController cc = new ClienteController(getContext());
                    String prestaNombre = cc.getPrestaNombreFromAvalEnCliente(tlNombreAval.getEditText().getText().toString().toUpperCase());
                    if (Objects.equals(prestaNombre, "1")) {
                        AlertDialog.Builder b = new AlertDialog.Builder(getContext());
                        b.setTitle("Aviso");
                        b.setMessage("¡Este cliente esta marcado como PrestaNombre!, llame a su administrador para pedir el desbloqueo del cliente");
                        b.setPositiveButton("Aceptar", null);

                        tlNombreAval.getEditText().setText("");

                        AlertDialog dialog = b.create();
                        dialog.show();
                    } else {
                        Aval aval = avalesAdapter.getItem(i);

                        //cliente_id = cliente.getId();
                        tlTelefonoAval.getEditText().setText(aval.getTelefono());
                        tlDireccionAval.getEditText().setText(aval.getDireccion());
                        tlOtrasReferenciasAval.getEditText().setText(aval.getOtras_referencias());
                        tlGarantiasAval.getEditText().setText(aval.getGarantias());
                    }
                } else {
                    Aval aval = avalesAdapter.getItem(i);

                    //cliente_id = cliente.getId();
                    tlTelefonoAval.getEditText().setText(aval.getTelefono());
                    tlDireccionAval.getEditText().setText(aval.getDireccion());
                    tlOtrasReferenciasAval.getEditText().setText(aval.getOtras_referencias());
                    tlGarantiasAval.getEditText().setText(aval.getGarantias());
                }
            }
        });

        avalesAutoCompleteTextView.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                previousLengthAval = s.length();
            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            @Override
            public void afterTextChanged(Editable s) {
                backSpaceAval = previousLengthAval > s.length();

                if (backSpaceAval && !aval_id.equals("")) {

                    avalesAutoCompleteTextView.setText("");
                    tlTelefonoAval.getEditText().setText("");
                    tlDireccionAval.getEditText().setText("");
                    tlOtrasReferenciasAval.getEditText().setText("");
                    tlGarantiasAval.getEditText().setText("");

                    aval_id = "";
                }
            }
        });
        rutas = new ArrayList<Ruta>();
        poblaciones = new ArrayList<Poblacion>();
        colocadoras = new ArrayList<Colocadora>();
        getRutas();
        rutasAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener() {

            @RequiresApi(api = Build.VERSION_CODES.N)
            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Ruta ruta = rutasAdapter.getItem(i);
                ruta_id = ruta.getId();

                if (poblacionesAutoCompleteTextView.getText().toString().length() > 0) {
                    poblacionesAutoCompleteTextView.setText("");
                }
                if (colocadorasAutoCompleteTextView.getText().toString().length() > 0) {
                    colocadorasAutoCompleteTextView.setText("");
                }

                List<Poblacion> poblacionesFiltro =
                        poblaciones.stream().filter(poblacion -> poblacion.getRuta_id().equals(ruta_id)).collect(Collectors.toList());

                poblacionesAdapter = new ArrayAdapter<Poblacion>(getContext(), android.R.layout.simple_dropdown_item_1line, poblacionesFiltro);
                poblacionesAutoCompleteTextView.setThreshold(1);
                poblacionesAutoCompleteTextView.setAdapter(poblacionesAdapter);

            }
        });


        /**
         *  POBLACIONES ADAPTER PARA AUTOCOMPLETTEXTVIEW
         */

        if (poblaciones.size() == 0) {
            getPoblaciones(ruta_id);
        }

        poblacionesAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @RequiresApi(api = Build.VERSION_CODES.N)
            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Poblacion poblacion = poblacionesAdapter.getItem(i);
                poblacion_id = poblacion.getId();

                if (colocadorasAutoCompleteTextView.getText().toString().length() > 0) {
                    colocadorasAutoCompleteTextView.setText("");
                }

                List<Colocadora> colocadorasFiltro =
                        colocadoras.stream().filter(colocadora -> colocadora.getPoblacion_id().equals(poblacion_id))
                                .collect(Collectors.toList());

                colocadorasAdapter = new ArrayAdapter<Colocadora>(getContext(), android.R.layout.simple_dropdown_item_1line, colocadorasFiltro);
                colocadorasAutoCompleteTextView.setThreshold(1);
                colocadorasAutoCompleteTextView.setAdapter(colocadorasAdapter);
            }
        });


        /**
         *  COLOCADORAS ADAPTER PARA AUTOCOMPLETTEXTVIEW
         */
        if (colocadoras.size() == 0) {
            getColocadoras();
        }

        colocadorasAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {

                Colocadora colocadora = colocadorasAdapter.getItem(i);
                colocadora_id = colocadora.getId();

            }
        });

        btnSubirFotos.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                AvalesFotosDialogFragment dialogFragment = new AvalesFotosDialogFragment();

                Bundle args = new Bundle();

                args.putString("aval", ""); // Pasar un JSON vacío o nulo
                args.putString("avalNombre", "Nuevo Aval"); // Puedes pasar un nombre predeterminado

                dialogFragment.setArguments(args);
                dialogFragment.show(getChildFragmentManager(), "AvalesFotosDialog");
            }
        });

        btnRegistrarAval.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                //sendExample();

                if (aval_id.equals("")) {
                    if (Validator.fieldValidation(tlNombreAval, "Ingresa un nombre de Aval")
                            && Validator.fieldValidation(tlTelefonoAval, "Ingresa un teléfono")
                            && Validator.fieldValidation(tlDireccionAval, "Ingresa una dirección")
                            && Validator.fieldValidation(tlOtrasReferenciasAval, "Ingresa otras referencias")
                            && Validator.fieldValidation(tlGarantiasAval, "Ingresa otras garantías")

                    ) {
                        if (!tlNombreAval.getEditText().getText().toString().isEmpty() || tlNombreAval.getEditText().getText() != null) {
                            AvalController ac = new AvalController(getContext());
                            String avalId = ac.getAvalByNombre(tlNombreAval.getEditText().getText().toString().toUpperCase());
                            if (!avalId.isEmpty() || avalId != null) {
                                ClienteController cc = new ClienteController(getContext());
                                String prestaNombre = cc.getPrestaNombreFromAvalEnCliente(tlNombreAval.getEditText().getText().toString().toUpperCase());
                                if (Objects.equals(prestaNombre, "1")) {
                                    AlertDialog.Builder b = new AlertDialog.Builder(getContext());
                                    b.setTitle("Aviso");
                                    b.setMessage("¡Este cliente esta marcado como PrestaNombre!, llame a su administrador para pedir el desbloqueo del cliente");
                                    b.setPositiveButton("Aceptar", null);

                                    AlertDialog dialog = b.create();
                                    dialog.show();
                                } else {
                                    registrarAvalNuevo();
                                }
                            } else {
                                registrarAvalNuevo();
                            }
                        } else {
                            registrarAvalNuevo();
                        }
                    }

                } else {
                    String nombre = avalesAutoCompleteTextView.getText().toString();
                    new MaterialAlertDialogBuilder(getActivity())
                            .setTitle("Aviso")
                            .setMessage("El aval " + nombre + " ya fue registrado")
                            .setPositiveButton("Ok", new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialogInterface, int i) {
                                }
                            })
                            .show();
                }
            }
        });


        configurarAutoCompleteTextView();
    }

    Button btnUbicacion;
    FusedLocationProviderClient client;

    @SuppressLint("MissingPermission")
    public void getCurrentLocation() {
        client = LocationServices
                .getFusedLocationProviderClient(
                        getActivity());
        LocationManager locationManager = (LocationManager)getActivity().getSystemService(Context.LOCATION_SERVICE);

        if (locationManager.isProviderEnabled(LocationManager.GPS_PROVIDER) || locationManager.isProviderEnabled(LocationManager.NETWORK_PROVIDER)) {
            client.getLastLocation().addOnCompleteListener(
                    new OnCompleteListener<Location>() {
                        @Override
                        public void onComplete(@NonNull Task<Location> task) {
                            Location location = task.getResult();

                            if (location != null) {
                                lat = String.valueOf(location.getLatitude());
                                lgt = String.valueOf(location.getLongitude());

                                Toast.makeText(getActivity(), "Ubicación obtenida", Toast.LENGTH_SHORT).show();
                            } else {
                                // When location result is null
                                // initialize location request
                                LocationRequest locationRequest = new LocationRequest()
                                        .setPriority(LocationRequest.PRIORITY_HIGH_ACCURACY)
                                        .setInterval(10000)
                                        .setFastestInterval(1000)
                                        .setNumUpdates(1);

                                LocationCallback locationCallback = new LocationCallback() {
                                    @Override
                                    public void
                                    onLocationResult(
                                            LocationResult
                                                    locationResult)
                                    {
                                        Location location1 = locationResult.getLastLocation();

                                        lat = String.valueOf(location1.getLatitude());
                                        lgt = String.valueOf(location1.getLongitude());

                                        Toast.makeText(getActivity(), "Ubicación obtenida", Toast.LENGTH_SHORT).show();
                                    }
                                };

                                client.requestLocationUpdates(locationRequest, locationCallback, Looper.myLooper());
                            }
                        }
                    });
        } else {
            startActivity(new Intent(
                    Settings.ACTION_LOCATION_SOURCE_SETTINGS)
                    .setFlags(Intent.FLAG_ACTIVITY_NEW_TASK));
        }
    }

    private void initElements(View view) {

        CurrentFragment.fragment = "AvalesCrearFragment";

        btnUbicacion = view.findViewById(R.id.btnUbicacion);

        btnUbicacion.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                getCurrentLocation();
            }
        });

        avalesAutoCompleteTextView = view.findViewById(R.id.acNombreAval);
        rutasAutoCompleteTextView = view.findViewById(R.id.acRuta);
        poblacionesAutoCompleteTextView = view.findViewById(R.id.acPoblacion);
        colocadorasAutoCompleteTextView = view.findViewById(R.id.acColocadora);
        tlNombreAval = view.findViewById(R.id.tlNombreAval);
        tlTelefonoAval = view.findViewById(R.id.tlTelefonoAval);
        tlDireccionAval = view.findViewById(R.id.tlDireccionAval);
        tlOtrasReferenciasAval = view.findViewById(R.id.tlOtrasReferenciasAval);
        tlGarantiasAval = view.findViewById(R.id.tlGarantiasAval);
        btnRegistrarAval = view.findViewById(R.id.btnRegistrarAval);
        btnSubirFotos = view.findViewById(R.id.btnSubirFotos);

        avalController = new AvalController(getActivity());
        rutaController = new RutaController(getActivity());
        poblacionController = new PoblacionController(getActivity());
        colocadoraController = new ColocadoraController(getActivity());

        pathsGarantiasAval = new ArrayList<>();
        pathsComprobantesAval = new ArrayList<>();
        pathsIneAval = new ArrayList<>();
        pathsFotoAval = new ArrayList<>();
        pathsFachadaAval = new ArrayList<>();

        archivosGeneral = new ArrayList<>();
    }

    @Override
    public void onCreateOptionsMenu(@NonNull Menu menu, @NonNull MenuInflater inflater) {
        super.onCreateOptionsMenu(menu, inflater);
    }
    private void getRutas() {
        if (rutaController.obtener().size() == 0) {

            vs = VolleyS.getInstance(this.getContext());
            requestQueue = vs.getRequestQueue();

            JSONObject data = new JSONObject();
            try {
                data.put("func", "rutasActivas");

            } catch (JSONException e) {
                e.printStackTrace();
            }

            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlRutas, data,
                    new Response.Listener<JSONObject>() {

                        @Override
                        public void onResponse(JSONObject response) {
                            try {

                                JSONArray data = (JSONArray) response.get("data");

                                for (int i = 0; i < data.length(); i++) {

                                    JSONObject obj = data.getJSONObject(i);

                                    Gson gson = new Gson();
                                    Ruta ruta = gson.fromJson(obj.toString(), Ruta.class);

                                    rutas.add(ruta);
                                    rutaController.nueva(ruta);

                                }

                                rutasAdapter = new ArrayAdapter<Ruta>(getContext(), android.R.layout.simple_dropdown_item_1line, rutas);
                                rutasAutoCompleteTextView.setThreshold(1);
                                rutasAutoCompleteTextView.setAdapter(rutasAdapter);

                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }
                    }, new Response.ErrorListener() {

                @Override
                public void onErrorResponse(VolleyError error) {

                    ErrorChecker.checker(error, getActivity());

                }
            });

            request.setRetryPolicy(new DefaultRetryPolicy(
                    30000,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            requestQueue.add(request);

        } else {
            rutas = rutaController.obtener();

            rutasAdapter = new ArrayAdapter<Ruta>(getContext(), android.R.layout.simple_dropdown_item_1line, rutas);
            rutasAutoCompleteTextView.setThreshold(1);
            rutasAutoCompleteTextView.setAdapter(rutasAdapter);
        }
    }


    private void getPoblaciones(String ruta_id) {
        if (poblacionController.obtener().size() == 0) {

            vs = VolleyS.getInstance(this.getContext());
            requestQueue = vs.getRequestQueue();

            JSONObject data = new JSONObject();
            try {
                data.put("func", "index");
            } catch (JSONException e) {
                e.printStackTrace();
            }

            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPoblaciones, data,
                    new Response.Listener<JSONObject>() {

                        @Override
                        public void onResponse(JSONObject response) {
                            try {

                                JSONArray data = (JSONArray) response.get("data");

                                for (int i = 0; i < data.length(); i++) {

                                    JSONObject obj = data.getJSONObject(i);

                                    Gson gson = new Gson();
                                    Poblacion poblacion = gson.fromJson(obj.toString(), Poblacion.class);

                                    poblaciones.add(poblacion);
                                    poblacionController.nueva(poblacion);

                                }

                                poblacionesAdapter = new ArrayAdapter<Poblacion>(getContext(), android.R.layout.simple_dropdown_item_1line, poblaciones);
                                poblacionesAutoCompleteTextView.setThreshold(1);
                                poblacionesAutoCompleteTextView.setAdapter(poblacionesAdapter);


                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }
                    }, new Response.ErrorListener() {

                @Override
                public void onErrorResponse(VolleyError error) {

                    ErrorChecker.checker(error, getActivity());

                }
            });

            request.setRetryPolicy(new DefaultRetryPolicy(
                    30000,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            requestQueue.add(request);
        } else {
            poblaciones = poblacionController.obtener();

            poblacionesAdapter = new ArrayAdapter<Poblacion>(getContext(), android.R.layout.simple_dropdown_item_1line, poblaciones);
            poblacionesAutoCompleteTextView.setThreshold(1);
            poblacionesAutoCompleteTextView.setAdapter(poblacionesAdapter);
        }
    }

    private void getColocadoras() {
        if (colocadoraController.obtener().size() == 0) {

            vs = VolleyS.getInstance(this.getContext());
            requestQueue = vs.getRequestQueue();

            JSONObject data = new JSONObject();
            try {
                data.put("func", "index");
            } catch (JSONException e) {
                e.printStackTrace();
            }

            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlColocadoras, data,
                    new Response.Listener<JSONObject>() {

                        @Override
                        public void onResponse(JSONObject response) {
                            try {

                                JSONArray data = (JSONArray) response.get("data");

                                for (int i = 0; i < data.length(); i++) {

                                    JSONObject obj = data.getJSONObject(i);


                                    Gson gson = new Gson();
                                    Colocadora colocadora = gson.fromJson(obj.toString(), Colocadora.class);

                                    colocadoras.add(colocadora);
                                    colocadoraController.nueva(colocadora);

                                }

                                colocadorasAdapter = new ArrayAdapter<Colocadora>(getContext(), android.R.layout.simple_dropdown_item_1line, colocadoras);
                                colocadorasAutoCompleteTextView.setThreshold(1);
                                colocadorasAutoCompleteTextView.setAdapter(colocadorasAdapter);

                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }
                    }, new Response.ErrorListener() {

                @Override
                public void onErrorResponse(VolleyError error) {

                    ErrorChecker.checker(error, getActivity());

                }
            });

            request.setRetryPolicy(new DefaultRetryPolicy(
                    30000,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            requestQueue.add(request);
        } else {
            colocadoras = colocadoraController.obtener();

            colocadorasAdapter = new ArrayAdapter<Colocadora>(getContext(), android.R.layout.simple_dropdown_item_1line, colocadoras);
            colocadorasAutoCompleteTextView.setThreshold(1);
            colocadorasAutoCompleteTextView.setAdapter(colocadorasAdapter);

        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
    }

    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        mViewModel = new ViewModelProvider(this).get(AvalesCrearViewModel.class);
        // TODO: Use the ViewModel
    }

    private void registrarAvalNuevo(){
        ProgressDialog dialog = new ProgressDialog(getActivity(),  R.style.AppMaterialAlertDialogStyle);
        dialog.setMessage("Guardando, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();

        Retrofit retrofit = new Retrofit.Builder()
                .baseUrl(API.url)
                .addConverterFactory(GsonConverterFactory.create())
                .build();

        RetrofitInterface retrofitInterface = retrofit.create(RetrofitInterface.class);

        if (!pathsIneAval.isEmpty())
        {
            pathsComprobantesAval.addAll(pathsIneAval);
        }
        if (!pathsFotoAval.isEmpty())
        {
            pathsComprobantesAval.addAll(pathsFotoAval);
        }
        if (!pathsFachadaAval.isEmpty())
        {
            pathsComprobantesAval.addAll(pathsFachadaAval);
        }
        HashSet<String> set = new HashSet<>(pathsComprobantesAval);
        pathsComprobantesAval.clear();
        pathsComprobantesAval.addAll(set);

        HashSet<String> set2 = new HashSet<>(pathsGarantiasAval);
        pathsGarantiasAval.clear();
        pathsGarantiasAval.addAll(set2);

        String nombre = tlNombreAval.getEditText().getText().toString();
        String nombreFormateado = nombre.replace("ñ", "n").replace("Ñ", "N");

        RequestBody func = RequestBody.create(MediaType.parse("multipart/form-data"), "createAPP");
        RequestBody nombre_aval = RequestBody.create(MediaType.parse("multipart/form-data"), nombreFormateado);
        RequestBody direccion_aval = RequestBody.create(MediaType.parse("multipart/form-data"), tlDireccionAval.getEditText().getText().toString());
        RequestBody telefono_aval = RequestBody.create(MediaType.parse("multipart/form-data"), tlTelefonoAval.getEditText().getText().toString());
        RequestBody or_aval = RequestBody.create(MediaType.parse("multipart/form-data"), tlOtrasReferenciasAval.getEditText().getText().toString());
        RequestBody poblacionId = RequestBody.create(MediaType.parse("multipart/form-data"), poblacion_id);
        RequestBody colocadoraId = RequestBody.create(MediaType.parse("multipart/form-data"), colocadora_id);
        RequestBody garantias_aval = RequestBody.create(MediaType.parse("multipart/form-data"), tlGarantiasAval.getEditText().getText().toString());
        RequestBody rutaId = RequestBody.create(MediaType.parse("multipart/form-data"), ruta_id);
        RequestBody cantidad_archivos_garantias_aval = RequestBody.create(MediaType.parse("multipart/form-data"), pathsGarantiasAval.size()+"");
        RequestBody cantidad_archivos_aval = RequestBody.create(MediaType.parse("multipart/form-data"), pathsComprobantesAval.size()+"");
        RequestBody latitud = RequestBody.create(MediaType.parse("multipart/form-data"), lat);
        RequestBody longitud = RequestBody.create(MediaType.parse("multipart/form-data"), lgt);

        //Log.d("ARCHIVOS", "ARCHIVOS archivosGeneral: " + archivosGeneral.size());

        String direccion = tlDireccionAval.getEditText().getText().toString();
        String telefono = tlTelefonoAval.getEditText().getText().toString();
        String orCliente = tlOtrasReferenciasAval.getEditText().getText().toString();
        String garantias = tlGarantiasAval.getEditText().getText().toString();

        String cantidadGarantias = String.valueOf(pathsGarantiasAval.size());
        String cantidadArchivos = String.valueOf(pathsComprobantesAval.size());

        Call<ResponseMe> call = retrofitInterface.registrarAval(archivosGeneral, func, nombre_aval, direccion_aval, telefono_aval,
                rutaId, poblacionId, colocadoraId, or_aval, garantias_aval, cantidad_archivos_garantias_aval, cantidad_archivos_aval, latitud, longitud);

        call.enqueue(new Callback<ResponseMe>() {
            public void onResponse(Call<ResponseMe> call, retrofit2.Response<ResponseMe> response) {

                dialog.cancel();
                if (response.isSuccessful()) {

                    String serverId = response.body().getClienteId(); // Captura el ID desde la respuesta del servidor

                    registrarAvalEnSQLite(archivosGeneral,nombre, direccion, telefono, orCliente, garantias, ruta_id, poblacion_id, colocadora_id,cantidadGarantias,cantidadArchivos, serverId);
                    //Log.d("response", response.body().getMessage());
                    Toast.makeText(getActivity(), "El aval ha sido registrado", Toast.LENGTH_LONG).show();

                    dialog.cancel();
                    tlNombreAval.getEditText().setText("");
                    tlTelefonoAval.getEditText().setText("");
                    tlDireccionAval.getEditText().setText("");
                    rutasAutoCompleteTextView.setText("");
                    poblacionesAutoCompleteTextView.setText("");
                    colocadorasAutoCompleteTextView.setText("");
                    tlOtrasReferenciasAval.getEditText().setText("");
                    tlGarantiasAval.getEditText().setText("");

                    aval_id = "";
                    ruta_id = "";
                    poblacion_id = "";
                    colocadora_id = "";

                    lat = "";
                    lgt = "";
                    //btnUbicacion.setText("OBTENER UBICACIÓN");

                    pathsGarantiasAval.clear();
                    pathsComprobantesAval.clear();

                    archivosGeneral.clear();
                } else {
                    try {
                        String errorBody = response.errorBody().string();

                        // Verifica si el error es un JSON válido
                        if (errorBody.startsWith("{")) {
                            JSONObject jObjError = new JSONObject(errorBody);
                            new MaterialAlertDialogBuilder(getActivity())
                                    .setTitle("Aviso")
                                    .setMessage(jObjError.getString("message"))
                                    .setPositiveButton("Ok", new DialogInterface.OnClickListener() {
                                        @Override
                                        public void onClick(DialogInterface dialogInterface, int i) {
                                        }
                                    })
                                    .show();
                        } else {
                            // Si no es un JSON, simplemente muestra el mensaje tal cual
                            new MaterialAlertDialogBuilder(getActivity())
                                    .setTitle("Aviso")
                                    .setMessage(errorBody)
                                    .setPositiveButton("Ok", new DialogInterface.OnClickListener() {
                                        @Override
                                        public void onClick(DialogInterface dialogInterface, int i) {
                                        }
                                    })
                                    .show();
                        }

                    } catch (Exception e) {
                        Toast.makeText(getContext(), e.getMessage(), Toast.LENGTH_LONG).show();
                    }

                }
            }

            FusedLocationProviderClient client;

            @Override
            public void onFailure(Call<ResponseMe> call, Throwable t) {
                dialog.cancel();
                Log.d("TAG", "onFailure: "+t.getLocalizedMessage() + " | " + t.getMessage());
                if(t.getLocalizedMessage().contains("Unable to resolve host")){
                    String tipo="InsertAval";

                    registrarAvalEnSQLite(archivosGeneral,nombre, direccion, telefono, orCliente, garantias, ruta_id, poblacion_id, colocadora_id,cantidadGarantias,cantidadArchivos, "");

                    SolicitudSubida solicitud = new SolicitudSubida(archivosGeneral,nombre, direccion, telefono, orCliente, garantias, ruta_id, poblacion_id, colocadora_id, cantidadGarantias, cantidadArchivos,tipo,"","");
                    colaSolicitudes.agregarSolicitud(solicitud);

                    new MaterialAlertDialogBuilder(getActivity())
                            .setTitle("Aviso")
                            .setMessage("Se perdio la conexión y se guardarón los datos en local")
                            .setPositiveButton("Ok", new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialogInterface, int i) {
                                }
                            })
                            .show();

                    avalesAutoCompleteTextView.setText("");
                    tlTelefonoAval.getEditText().setText("");
                    tlDireccionAval.getEditText().setText("");
                    rutasAutoCompleteTextView.setText("");
                    poblacionesAutoCompleteTextView.setText("");
                    colocadorasAutoCompleteTextView.setText("");
                    tlOtrasReferenciasAval.getEditText().setText("");
                    tlGarantiasAval.getEditText().setText("");

                    aval_id="";
                    ruta_id = "";
                    poblacion_id = "";
                    colocadora_id = "";

                    pathsGarantiasAval.clear();
                    pathsComprobantesAval.clear();

                }
            }
        });
    }

    private void registrarAvalEnSQLite(List<MultipartBody.Part> archivosGeneral2, String nombre, String direccion, String telefono, String otrasReferencias, String garantias, String rutaId, String poblacionId, String colocadoraId, String cantidadGarantias, String cantidadArchivos, String idServer) {
        // Abrimos la base de datos para escritura
        DatabaseHelper dbHelper = new DatabaseHelper(requireContext());
        SQLiteDatabase db = dbHelper.getWritableDatabase();

        // Verificar si el nombre del cliente ya existe
        if (verificarAvalExistente(db, nombre)) {
            Log.d("SQLite", "El aval con nombre " + nombre + " ya existe en la base de datos.");
            Toast.makeText(requireContext(), "El aval con este nombre ya existe.", Toast.LENGTH_LONG).show();
            db.close();
            return;
        }

        if(idServer!="")
        {
            aval_id = idServer;
        }
        else
        {
            aval_id = String.valueOf(obtenerSiguienteIdAval(db));
        }
        // Crear el ContentValues para insertar el cliente
        ContentValues valores = new ContentValues();
        valores.put("id", aval_id); // Asignamos el nuevo ID
        valores.put("nombre_completo", nombre);
        valores.put("direccion", direccion);
        valores.put("telefono", telefono);
        valores.put("otras_referencias", otrasReferencias);
        valores.put("garantias", garantias);
        valores.put("ruta_id", rutaId);
        valores.put("poblacion_id", poblacionId);
        valores.put("colocadora_id", colocadoraId);
        Calendar calendar = Calendar.getInstance();

        // Restar 10 minutos
        calendar.add(Calendar.MINUTE, -10);

        // Obtener la nueva fecha después de restar los 10 minutos
        Date nuevaFecha = calendar.getTime();

        // Formatear la fecha en el formato que necesitas (yyyy-MM-dd HH:mm:ss)
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", new Locale("es", "MX"));
        String fechaRestada = dateFormat.format(nuevaFecha);

        // Ahora puedes guardar la fecha restada en la base de datos
        valores.put("created_at", fechaRestada);
        valores.put("updated_at", fechaRestada);

        // Insertar el nuevo cliente en la base de datos
        long resultado = db.insert("avales", null, valores);

        if (resultado != -1) {
            Log.d("SQLite", "Cliente registrado con éxito en SQLite con ID: " + aval_id);
        } else {
            Log.d("SQLite", "Error al registrar el cliente en SQLite.");
        }

        db.close(); // Cerrar la conexión a la base de datos
    }

    // Método para verificar si un cliente con el mismo nombre ya existe en la base de datos
    private boolean verificarAvalExistente(SQLiteDatabase db, String nombre) {
        String query = "SELECT COUNT(*) FROM avales WHERE nombre_completo = ?";
        Cursor cursor = db.rawQuery(query, new String[]{nombre});
        boolean existe = false;

        if (cursor.moveToFirst()) {
            existe = cursor.getInt(0) > 0;
        }
        cursor.close();

        return existe;
    }

    // Método para obtener el siguiente ID disponible en la tabla clientes
    private int obtenerSiguienteIdAval(SQLiteDatabase db) {
        int ultimoId = 0;
        Cursor cursor = db.rawQuery("SELECT MAX(id) FROM avales", null);

        if (cursor.moveToFirst()) {
            ultimoId = cursor.getInt(0);
        }
        cursor.close();

        return ultimoId + 1;
    }

    private void configurarAutoCompleteTextView() {
        // Obtener la lista de avales
        List<Cliente> listaClientes = obtenerListaClientes();

        // Ordenar por ID en orden descendente
        if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.N) {
            listaClientes.sort((cliente1, cliente2) -> {
                // Convertir los IDs a números para compararlos
                int id1 = Integer.parseInt(cliente1.getId());
                int id2 = Integer.parseInt(cliente2.getId());
                return Integer.compare(id2, id1); // Orden descendente
            });
        } else {
            // Para versiones anteriores de Android
            Collections.sort(listaClientes, new Comparator<Cliente>() {
                @Override
                public int compare(Cliente cliente1, Cliente cliente2) {
                    int id1 = Integer.parseInt(cliente1.getId());
                    int id2 = Integer.parseInt(cliente2.getId());
                    return Integer.compare(id2, id1); // Orden descendente
                }
            });
        }

        // Extraer los nombres de los clientes para mostrar en el AutoCompleteTextView
        List<String> nombresClientes = new ArrayList<>();
        for (Cliente cliente : listaClientes) {
            nombresClientes.add(cliente.getNombre_completo());
        }

        // Configurar el adaptador
        ArrayAdapter<String> adapter = new ArrayAdapter<>(
                requireContext(),
                android.R.layout.simple_dropdown_item_1line,
                nombresClientes
        );
        avalesAutoCompleteTextView.setAdapter(adapter);

        // Manejar la selección de un aval
        avalesAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int position, long id) {
                Log.d("aksdklaksldkl", tlNombreAval.getEditText().getText().toString());
                if (!tlNombreAval.getEditText().getText().toString().isEmpty() || tlNombreAval.getEditText().getText() != null) {
                        ClienteController cc = new ClienteController(getContext());
                        String prestaNombre = cc.getPrestaNombreFromAvalEnCliente(tlNombreAval.getEditText().getText().toString().toUpperCase());
                        Log.d("aksdklaksldkl122", prestaNombre);
                        if (Objects.equals(prestaNombre, "1")) {
                            AlertDialog.Builder b = new AlertDialog.Builder(getContext());
                            b.setTitle("Aviso");
                            b.setMessage("¡Este cliente esta marcado como PrestaNombre!, llame a su administrador para pedir el desbloqueo del cliente");
                            b.setPositiveButton("Aceptar", null);

                            tlNombreAval.getEditText().setText("");

                            AlertDialog dialog = b.create();
                            dialog.show();
                        } else {
                            String nombreSeleccionado = (String) adapterView.getItemAtPosition(position);

                            // Buscar el aval correspondiente en la lista
                            Cliente clienteSeleccionado = null;
                            if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.N) {
                                clienteSeleccionado = listaClientes.stream()
                                        .filter(cliente -> cliente.getNombre_completo().equals(nombreSeleccionado))
                                        .findFirst()
                                        .orElse(null);
                            } else {
                                for (Cliente cliente : listaClientes) {
                                    if (cliente.getNombre_completo().equals(nombreSeleccionado)) {
                                        clienteSeleccionado = cliente;
                                        break;
                                    }
                                }
                            }

                            if (clienteSeleccionado != null) {
                                // Llenar los campos con los datos del aval seleccionado
                                llenarCamposCliente(clienteSeleccionado);
                            }
                        }
                    } else {
                    String nombreSeleccionado = (String) adapterView.getItemAtPosition(position);

                    // Buscar el aval correspondiente en la lista
                    Cliente clienteSeleccionado = null;
                    if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.N) {
                        clienteSeleccionado = listaClientes.stream()
                                .filter(cliente -> cliente.getNombre_completo().equals(nombreSeleccionado))
                                .findFirst()
                                .orElse(null);
                    } else {
                        for (Cliente cliente : listaClientes) {
                            if (cliente.getNombre_completo().equals(nombreSeleccionado)) {
                                clienteSeleccionado = cliente;
                                break;
                            }
                        }
                    }

                    if (clienteSeleccionado != null) {
                        // Llenar los campos con los datos del aval seleccionado
                        llenarCamposCliente(clienteSeleccionado);
                    }
                }
            }
        });

        avalesAutoCompleteTextView.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                // No se requiere implementación
            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                // Verificar si el usuario está borrando texto y el texto resultante tiene menos de 1 carácter
                //if (before > count && s.length() < 1) {
                    //limpiarCampos();
                //}
            }

            @Override
            public void afterTextChanged(Editable s) {
                // No se requiere implementación
            }
        });

    }

    private void limpiarCampos() {
        tlNombreAval.getEditText().setText("");
        tlTelefonoAval.getEditText().setText("");
        tlDireccionAval.getEditText().setText("");
        tlOtrasReferenciasAval.getEditText().setText("");
        tlGarantiasAval.getEditText().setText("");

        rutasAutoCompleteTextView.setText("", false);
        poblacionesAutoCompleteTextView.setText("", false);
        colocadorasAutoCompleteTextView.setText("", false);
    }

    private void llenarCamposCliente(Cliente cliente) {
        if (cliente != null) {
            // Llenar los campos con los datos del aval
            tlNombreAval.getEditText().setText(cliente.getNombre_completo());
            tlTelefonoAval.getEditText().setText(cliente.getTelefono());
            tlDireccionAval.getEditText().setText(cliente.getDireccion());
            tlOtrasReferenciasAval.getEditText().setText(cliente.getOtras_referencias());
            tlGarantiasAval.getEditText().setText(cliente.getGarantias());

            // Seleccionar ruta en rutasAutoCompleteTextView
            if (cliente.getRuta_cliente() != null) {
                for (int i = 0; i < rutas.size(); i++) {
                    if (rutas.get(i).getId().equals(cliente.getRuta_cliente())) {
                        rutasAutoCompleteTextView.setText(rutas.get(i).toString(), false);
                        break;
                    }
                }
            }

            // Seleccionar población en poblacionesAutoCompleteTextView
            if (cliente.getPoblacion_cliente() != null) {
                for (int i = 0; i < poblaciones.size(); i++) {
                    if (poblaciones.get(i).getId().equals(cliente.getPoblacion_cliente())) {
                        poblacionesAutoCompleteTextView.setText(poblaciones.get(i).toString(), false);
                        break;
                    }
                }
            }

            // Seleccionar colocadora en colocadorasAutoCompleteTextView
            if (cliente.getColocadora_id() != null) {
                for (int i = 0; i < colocadoras.size(); i++) {
                    if (colocadoras.get(i).getId().equals(cliente.getColocadora_id())) {
                        colocadorasAutoCompleteTextView.setText(colocadoras.get(i).toString(), false);
                        break;
                    }
                }
            }
        }
    }

    private List<Cliente> obtenerListaClientes() {
        List<Cliente> listaClientes = new ArrayList<>();
        DatabaseHelper dbHelper = new DatabaseHelper(requireContext());
        SQLiteDatabase db = dbHelper.getReadableDatabase();

        String sqlQuery = "SELECT * FROM clientes ORDER BY nombre_completo ASC";
        Cursor cursor = db.rawQuery(sqlQuery, null);

        if (cursor != null && cursor.moveToFirst()) {
            do {
                Cliente cliente = new Cliente(
                        cursor.getString(cursor.getColumnIndexOrThrow("id")),
                        cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo")),
                        cursor.getString(cursor.getColumnIndexOrThrow("direccion")),
                        cursor.getString(cursor.getColumnIndexOrThrow("telefono")),
                        cursor.getString(cursor.getColumnIndexOrThrow("garantias")),
                        cursor.getString(cursor.getColumnIndexOrThrow("otras_referencias")),
                        cursor.getString(cursor.getColumnIndexOrThrow("ruta_id")),
                        cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id")),
                        cursor.getString(cursor.getColumnIndexOrThrow("colocadora_id")),
                        cursor.getString(cursor.getColumnIndexOrThrow("prestanombre"))
                );
                listaClientes.add(cliente);
            } while (cursor.moveToNext());

            cursor.close();
        } else {
            Log.d("SQLiteCliente", "No se encontraron clientes en la base de datos.");
        }

        db.close();
        return listaClientes;
    }


}